package gov.va.med.mhv.bluebutton.service.impl;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.bluebutton.DownloadYourReportService;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportDTO;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportSelectionsDTO;
import gov.va.med.mhv.bluebutton.transfer.MhvDownloadReportDTO;
import gov.va.med.mhv.bluebutton.webservice.BlueButtonWebService;
import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

@Component
public class BlueButtonWebServiceImpl implements BlueButtonWebService {
	private static final Log log = LogFactory.getLog(BlueButtonWebServiceImpl.class);

	@Resource(name = "activityProxy")
	private AccountActivityCreatorService activityProxy;

	@Resource
	private DownloadYourReportService downloadYourReportService;
	
	@Override
	public BlueButtonReportDTO generateReport(Long userProfileId, BlueButtonReportSelectionsDTO s) {
		downloadYourReportService.generateSelectedDownload(userProfileId, s);
		MhvDownloadReportDTO mhvDownloadReportDTO = downloadYourReportService.getDownloadedReport(userProfileId);
		BlueButtonReportDTO reportDto = new BlueButtonReportDTO();
		reportDto.setFilename(mhvDownloadReportDTO.getFileName());
		reportDto.setFilesize(mhvDownloadReportDTO.getFileSize());
		reportDto.setReportId(mhvDownloadReportDTO.getDownloadReportId());
		//Hard Coding to bypass NullP. Not sure where it is required.
		reportDto.setType(ReportTypeEnum.TXT);

		//GET the TXT size and filename
		//COMPUTE THE PDF SIZE based on a factor  -- fileSz = (fileSz*5)+21658L
		
		try {
			if(mhvDownloadReportDTO.getErrorMessage() != null) {
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, false, 
						ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.CUSTOM_DOWNLOAD_REQUESTED, ""));
			}	
			else {
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, 
						ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.CUSTOM_DOWNLOAD_REQUESTED, ""));
			}	
		} catch (MHVException e) {
			log.error("MHVException occurred" +e);
		}
		
		return reportDto;
	}

	/**
	 * REQUIRES A SESSION TOKEN FROM API
	 */
	@Override
	public Response getBluebuttonReport(Long reportId, String type) {
		//GET USER FROM SESSION
		Session session =  CacheHandler.getInstance().getSession();
		Long userProfileId = session.getUserId();
		ReportTypeEnum reportType = ReportTypeEnum.valueOfByType(type);
		try {
			//Call the service to retrieve and convert the report
			if(ReportTypeEnum.isTXT(reportType))
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VIEW_MY_CUSTOM_DATA, ""));
			else if(ReportTypeEnum.isPDF(reportType))
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VIEW_MY_CUSTOM_DATA_PDF, ""));
			else if(ReportTypeEnum.isPDFDL(reportType))
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA_PDF, ""));
			else if(ReportTypeEnum.isTXTDL(reportType))
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA, ""));
				
			return downloadYourReportService.generateDownload(userProfileId, reportId, reportType);
		} catch (Exception e1) {
			return Response.status(400).header("Cache-Control","no-cache").build();
		}
	}
	
	@Override
	public MhvDownloadReportDTO getDownloadedReport(Long userProfileId) {
		return downloadYourReportService.getDownloadedReport(userProfileId);
	}

	@Override
	public Response generateSelectedDownload(Long userprofileId,
			BlueButtonReportSelectionsDTO genRepTO) {
		
		return downloadYourReportService.generateSelectedDownload(userprofileId, genRepTO);
	}

	@Override
	public Response generateDownload(Long userprofileId, Long downloadReportId,
			ReportTypeEnum reportType) {
		
		return downloadYourReportService.generateDownload(userprofileId, downloadReportId, reportType);
	}

}
